#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Julia's OrbMod01.fsh   by   darkeclipz
//https://www.shadertoy.com/view/WdyfDd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// set to 0 or 1
#define SIMPLE 0

#define R iResolution.xy
#define pi 3.14159
float ln2 = log(2.);
vec3 c0 = vec3(0,2,5)/255.;
vec3 c1 = vec3(8,45,58)/255.;
vec3 c2 = vec3(38,116,145)/255.;
vec3 c3 = vec3(167,184,181)/260.;
vec3 c4 = vec3(38,116,145)/255.;

vec3 cmap(float t) {
    vec3 col = vec3(0);
    col = mix( c0,  c1, smoothstep(0. , .2, t));
    col = mix( col, c2, smoothstep(.2, .4 , t));
    col = mix( col, c3, smoothstep(.4 , .6, t));
    col = mix( col, c4, smoothstep(.6,  .8, t));
    col = mix( col, c0, smoothstep(.8, 1.,  t));
    return col;
}

float julia(vec2 z, vec2 c, float n) {
    float i = 0.;
    for(i=0.; i < n; i++) {
        z = abs(z);
        z = mat2(z, -z.y, z.x) * z + c;
        if( dot(z,z) > 4. ) break;
    }
    return (i - log(log(dot(z,z))/ln2)/ln2) / n;
}

vec3 ripple(float t) {
    float a = 0.4;
    float b = 0.92;
    vec3 black = vec3(0);
    vec3 white = vec3(1);
    vec3 col = mix(black, white, t/a);
    col = black * smoothstep(0.0, a, t) + white * smoothstep(a, b, t) + black - smoothstep(b, 1.0, t);
	return 1.-col;    
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = 1.1*(2.*fragCoord-R)/R.y;
    float a = 0.2;
    float b = 0.05;
    float t = iTime/4.;
    float t1 = a*(cos(t)*.5+.5)-a/2.;
    float t2 = b*(cos(2.23*t)*.5 +.5)-b/2.;
    float t3 = b*(cos(5.78*t)*.5 +.5)-b/2.;
    float t4 = b*(cos(7.66*t)*.5 +.5)-b/2.;
    float t5 = b*(cos(-3.14*t)*.5 +.5)-b/2.;
    
    // https://en.wikipedia.org/wiki/Coordinate_systems_for_the_hyperbolic_plane
    vec2 uv2 = uv*uv;
    vec2 uvh = vec2(uv.x / (1.0+sqrt(1.0-uv2.x-uv2.y)), 
                    uv.y / (1.0+sqrt(1.0-uv2.x-uv2.y)));
    uvh *= mat2(cos(3.0*t1+t2), sin(2.0*t1+t3), 
                sin(3.0*t1+t4), cos(5.0*t1+t5));
    
    // Rendering of two Julia Burning Ship fractals.
    vec3 col = vec3(0);
    float f1 = julia(uvh, vec2(-0.185, 0.192), 100.+30.*t2*1.0/b+b/2.);
    float f2 = julia(2.2*uvh, vec2(-0.144, 0.228), 70.+20.*t3*1.0/b+b/2.);
    float f3 = julia(7.4*uvh, vec2(-0.185, 0.192), 60.);
    float sn = f1 + f2 + f3;
    col = cmap(fract(2.*(clamp(sn, .0, 1.) + t/4.)))
        #if !SIMPLE
        * (0.2 +     ripple(fract(15.*sn))) 
        * (0.2 + 0.8*ripple(fract(20.*sn + 0.5)))
        * (0.4 + 0.6*ripple(fract(35.*sn)))
        #endif
        ;
   
    // https://stackoverflow.com/questions/9604132/how-to-project-a-point-on-to-a-sphere
    vec3 p = vec3(uv, 0.5);
    vec3 n = p / length(p);
    vec3 light = vec3(3.75,3.75,8.1);
    vec3 v = vec3(0.,0,0.5);

    // shade
    vec3 l = normalize(p - light);
    vec3 h = normalize(v + l);
    vec3 m_spec = vec3(0.6);
    vec3 s_spec = vec3(232, 249, 255)/255.;
    float m_gsl = 1.8;
    vec3 c_spec = (m_spec * s_spec) * pow(max(-dot(n, h), 0.), m_gsl);
    vec3 m_diff = col;
    vec3 s_diff = vec3(1.0);
    vec3 c_diff = (s_diff * m_diff) * max(-dot(n, l), 0.);
    vec3 g_amb = m_diff;   
    col = c_spec + c_diff + g_amb;  
    
    
    // cut
    col *= clamp(smoothstep(0.99, 0.97, length(uv)), 0., 1.);
    
    // shadow on edges
    col *= smoothstep(1.0, 0.0, length(uv) - 0.42);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

